/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.ui.action;

import java.io.File;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupMode;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Console;
import oracle.install.commons.util.ResourceURL;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.util.SetupSummary;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public abstract class AbstractFinishAction
implements Action {
    @Override
    public void execute(FlowContext flowContext) {
        File oracleHome = new File(this.getOracleHome(flowContext));
        SetupSummary summary = SetupSummary.getInstance();
        summary.beginUpdate();
        if (this.showConfigToolExecutionMsg(flowContext)) {
            Application application = Application.getInstance();
            summary.append(application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "configTools.message"), "", new File(new File(oracleHome, "cfgtoollogs").getPath(), OiiolTextLogger.s_sConfigToolCommands).getPath()));
        }
        if (this.updateSummaryWithReadmeText(flowContext)) {
            summary.append(DriverHelper.getReadmeFileContent(oracleHome));
        }
        summary.endUpdate();
        this.printSummary();
    }

    protected void printSummary() {
        String msg = SetupSummary.getInstance().getText();
        if (msg != null && msg.length() > 0 && ((SetupDriver)SetupDriver.getInstance()).getSetupMode() == SetupMode.SILENT) {
            Console.println(msg + "\n");
        }
    }

    @Override
    public Route transition(FlowContext flowContext) {
        return null;
    }

    public abstract String getOracleHome(FlowContext var1);

    public boolean showConfigToolExecutionMsg(FlowContext flowContext) {
        return Application.getInstance().getArguments().contains("-noconfig");
    }

    public boolean updateSummaryWithReadmeText(FlowContext flowContext) {
        String home = this.getOracleHome(flowContext);
        return home != null && new File(home).exists() && ((SetupDriver)SetupDriver.getInstance()).getSetupMode() == SetupMode.INTERACTIVE && !Boolean.getBoolean("readme.exist");
    }
}

